import { FC } from 'react';

import { Close, ErrorOutline } from '@client/shared/icons';
import { Text } from '@yandex-id/components';
import { Button } from '@yandex-id/components/next';

import { Snackbar, SnackbarComponentProps } from '../Snackbar';

import styles from './ErrorSnackbar.module.css';

export const ErrorSnackbar: FC<SnackbarComponentProps> = (props) => {
  const { onClose, children } = props;

  return (
    <Snackbar>
      <Snackbar.Before>
        <Text className={styles.beforeText} color="negative">
          <ErrorOutline />
        </Text>
      </Snackbar.Before>

      <Text variant="text-m">{children}</Text>

      <Snackbar.After>
        <Button variant="clear" size="m" onPress={onClose}>
          <Close />
        </Button>
      </Snackbar.After>
    </Snackbar>
  );
};
