import { FC } from 'react';

import { Text } from '@yandex-id/components';

import { Spinner } from '../../Spinner';
import { Snackbar, SnackbarComponentProps } from '../Snackbar';

export const LoadingSnackbar: FC<SnackbarComponentProps> = (props) => {
  const { children } = props;

  return (
    <Snackbar>
      <Snackbar.Before>
        <Spinner size={24} />
      </Snackbar.Before>
      <Text variant="text-m">{children}</Text>
    </Snackbar>
  );
};
