import { FC } from 'react';

import { CheckOutline, Close } from '@client/shared/icons';
import { Text } from '@yandex-id/components';
import { Button } from '@yandex-id/components/next';

import { Snackbar, SnackbarComponentProps } from '../Snackbar';

export const SuccessSnackbar: FC<SnackbarComponentProps> = (props) => {
  const { onClose, children } = props;

  return (
    <Snackbar duration={5000} onClose={onClose}>
      <Snackbar.Before>
        <CheckOutline />
      </Snackbar.Before>

      <Text variant="text-m">{children}</Text>

      <Snackbar.After>
        <Button variant="clear" size="m" onPress={onClose}>
          <Close />
        </Button>
      </Snackbar.After>
    </Snackbar>
  );
};
