import { VFC } from 'react';

import { ProgressCircle, ProgressCircleProps } from '@yandex-id/components';

export interface SpinnerProps {
  size?: ProgressCircleProps['size'];
  className?: string;
}

export const Spinner: VFC<SpinnerProps> = (props) => {
  const { size = 24, className } = props;

  return <ProgressCircle variant="brand" size={size} indeterminate className={className} />;
};
