import cn from 'classnames';
import React, { FC, HTMLAttributes } from 'react';

import { Text, TextProps } from '@yandex-id/components';
import { createSlot, useSlots } from '@yandex-id/components/libs/slots';

import styles from './TextPromo.module.css';

const SuperTitleSlot = createSlot<TextProps>('TextPromo.SuperTitle');
const TitleSlot = createSlot<TextProps>('TextPromo.Title');
const DescriptionSlot = createSlot<TextProps>('TextPromo.Description');

export interface TextPromoProps extends HTMLAttributes<HTMLDivElement> {
  align?: 'start' | 'center' | 'end';
}

const TextPromo: FC<TextPromoProps> = (props) => {
  const { className, align = 'start', ...otherProps } = props;
  const slots = useSlots(props, { defaultSlot: TitleSlot });
  const supertitle = slots.get(SuperTitleSlot);
  const title = slots.get(TitleSlot);
  const description = slots.get(DescriptionSlot);

  return (
    <div className={cn(styles.root, className)} data-align={align} {...otherProps}>
      <div className={styles.inner}>
        {supertitle && (
          <Text variant="text-l-long" {...supertitle.props}>
            {supertitle.rendered}
          </Text>
        )}
        <Text variant="heading-l" weight="bold" {...title?.props}>
          {slots.children}
        </Text>
      </div>

      {description && (
        <Text variant="text-m-long" {...description.props}>
          {description.rendered}
        </Text>
      )}
    </div>
  );
};

const _TextPromo = Object.assign(TextPromo, {
  SuperTitle: SuperTitleSlot,
  Title: TitleSlot,
  Description: DescriptionSlot,
});

export { _TextPromo as TextPromo };
