import { ReactNode, VFC } from 'react';

import { FormatDurationOptions, formatDuration } from '@client/shared/libs/format-duration';
import { UseTimerProps, UseTimerResult, useTimer } from '@client/shared/libs/use-timer';

const DEFAULT_FORMAT_OPTIONS: FormatDurationOptions = { minute: '2-digit', second: '2-digit' };

export interface TimerProps extends UseTimerProps {
  formatOptions?: FormatDurationOptions;
  children?: (result: UseTimerResult & { text: string }) => ReactNode;
}

export const Timer: VFC<TimerProps> = (props) => {
  const { children, formatOptions = DEFAULT_FORMAT_OPTIONS } = props;
  const result = useTimer(props);
  const text = formatDuration(result.duration, formatOptions);

  if (typeof children === 'function') {
    return <>{children({ ...result, text })}</>;
  }

  return <>{text}</>;
};
