import cx from 'classnames';
import { VFC } from 'react';

import { Skeleton } from '../Skeleton';

import styles from './UserInfo.module.css';

export const UserInfoSkeleton: VFC = () => (
  <div className={cx(styles.root, styles.root_skeleton)}>
    <Skeleton width="100%" height="56" backgroundColor="var(--id-color-decor-neutral-50)">
      <path
        width={56}
        height={56}
        fillRule="evenodd"
        clipRule="evenodd"
        d="M55.999 28.001C55.999 43.465 43.463 56.001 27.999 56.001C12.5351 56.001 -0.000976562 43.465 -0.000976562 28.001C-0.000976562 12.537 12.5351 0.000976562 27.999 0.000976562C25.9444 0.000976562 23.8961 0.227115 21.891 0.675308L23.1733 6.41185C13.2791 8.61378 5.88196 17.4435 5.88196 28.001C5.88196 40.216 15.7842 50.1182 27.9991 50.1182C40.2141 50.1182 50.1163 40.216 50.1163 28.001L55.999 28.001ZM27.999 0.000976562C43.463 0.000976562 55.999 12.537 55.999 28.001C55.999 25.9464 55.7729 23.8981 55.3247 21.893L49.5883 23.1752C47.3864 13.281 38.5566 5.88381 27.9991 5.88381H27.999V0.000976562ZM27.9989 44.5549C34.8118 44.5549 40.6634 40.4392 43.2032 34.5585L37.8113 32.2078C36.1787 36.0108 32.3998 38.6744 27.9989 38.6744C23.6442 38.6744 19.8987 36.0666 18.2387 32.3274L12.8469 34.6782C15.414 40.4949 21.2323 44.5549 27.9989 44.5549Z"
      />
      <rect x="64" y="12" rx="6" width="99" height="12" />
      <rect x="64" y="32" rx="6" width="118" height="12" />
    </Skeleton>
  </div>
);
