import { flow, makeObservable, observable } from 'mobx';

import { fetchAccountActions } from '@client/shared/api';
import { AsyncStore, HydratableStore } from '@client/shared/libs/mobx-next';
import { AccountAction } from '@shared/types/account';
import { ApiResponse } from '@shared/types/response';

export class AccountActionsStore implements HydratableStore, AsyncStore<AccountAction[]> {
  @observable data: AccountAction[] = [];

  @observable isLoading = false;

  private isHydrated = false;

  constructor() {
    makeObservable(this);
  }

  hydrate(context: { accountActions?: ApiResponse<AccountAction[]> }) {
    if (context.accountActions && context.accountActions.status === 'success') {
      this.data = context.accountActions.data;
      this.isHydrated = true;
    }
  }

  start = flow(function* (this: AccountActionsStore) {
    if (this.isHydrated) {
      return;
    }

    this.isLoading = true;
    this.data = yield fetchAccountActions();
    this.isLoading = false;
  });
}
