import { VFC } from 'react';

import { Grid, Text } from '@client/shared/ui-kit';
import { AccountAction } from '@shared/types/account';

import { ActionItem, ActionPressEventHandler } from '../ActionItem';

import styles from './ActionGroup.module.css';

export interface ActionGroupProps {
  title: string;
  actions: AccountAction[];
  onPressAction: ActionPressEventHandler;
}

export const ActionGroup: VFC<ActionGroupProps> = (props) => {
  const { title, actions, onPressAction } = props;

  return (
    <Grid className={styles.root}>
      <Text as="h3" variant="text-m" color="secondary">
        {title}
      </Text>

      <Grid className={styles.actions}>
        {actions.map((action, index) => (
          <ActionItem key={index} action={action} onPress={onPressAction} />
        ))}
      </Grid>
    </Grid>
  );
};
