import { VFC, useCallback } from 'react';

import { logProps } from '@client/shared/libs/metrika';
import { useTimestampFormat } from '@client/shared/libs/use-timestamp-format';
import { AccountAction } from '@shared/types/account';
import { ListItemView, Text } from '@yandex-id/components';

import { ActionIcon } from '../ActionIcon';
import { getActionText } from './i18nHelpers';

import styles from './ActionItem.module.css';

export interface ActionPressEvent {
  data: AccountAction;
}

export type ActionPressEventHandler = (event: ActionPressEvent) => void;

export interface ActionItemProps {
  action: AccountAction;
  onPress: ActionPressEventHandler;
}

export const ActionItem: VFC<ActionItemProps> = (props) => {
  const { action, onPress } = props;
  const { timestamp, geolocation } = action;
  const { region } = geolocation;

  const formattedDate = useTimestampFormat(timestamp);

  const handlePress = useCallback(() => {
    onPress({ data: action });
  }, [action, onPress]);

  return (
    <ListItemView
      {...logProps('listitem.account-action')}
      className={styles.root}
      onPress={handlePress}
      tabIndex={0}
    >
      <ListItemView.Before>
        <ActionIcon action={action} />
      </ListItemView.Before>
      <ListItemView.Content>
        <Text variant="text-m-long">{getActionText(action)}</Text>
        <Text variant="text-s" color="secondary">
          {formattedDate}
          {region && <span>, {region}</span>}
        </Text>
      </ListItemView.Content>
    </ListItemView>
  );
};
