import { AccountAction, AccountActionType, AccountAuthType } from '@shared/types/account';

import { i18n } from './i18n';

const AUTH_TYPE_TEXTS: Record<AccountAuthType, () => string> = {
  [AccountAuthType.Calendar]: () => i18n('Календарь'),
  [AccountAuthType.IMAP]: () => i18n('Почта'),
  [AccountAuthType.POP3]: () => i18n('Почта'),
  [AccountAuthType.SMTP]: () => i18n('Почта'),
  [AccountAuthType.Web]: () => i18n('Браузер'),
  [AccountAuthType.WebDav]: () => i18n('Облачный сервис'),
  [AccountAuthType.XMPP]: () => i18n('Чат'),
  [AccountAuthType.PasswordOAuth]: () => i18n('Мобильное устройство'),
};

export function getActionText(action: AccountAction) {
  switch (action.type) {
    case AccountActionType.EmailAdd:
      return i18n('Добавлена почта для восстановления');

    case AccountActionType.EmailRemove:
      return i18n('Удалена почта для восстановления');

    case AccountActionType.EmailRemoveAll:
      return i18n('Отвязаны все почты для восстановления');

    case AccountActionType.GlobalLogout:
      return i18n('Выход на всех устройствах');

    case AccountActionType.QuestionsChange:
      return i18n('Обновлён контрольный вопрос');

    case AccountActionType.QuestionsRemove:
      return i18n('Удалён контрольный вопрос');

    case AccountActionType.PasswordChange:
      return i18n('Изменён пароль');

    case AccountActionType.PasswordRemove:
      return i18n('Удалён пароль');

    case AccountActionType.WebSessionsRevoked:
      return i18n('Выход на всех устройствах');

    case AccountActionType.TokensRevoked:
      return i18n('Отозваны токены');

    case AccountActionType.AppPasswordsRevoked:
      return i18n('Отозваны пароли приложений');

    case AccountActionType.PersonalData:
      return i18n('Обновлены персональные данные');

    case AccountActionType.SecurePhoneSet:
      return `${i18n('Добавлен телефон')} ${action.phoneSet}`;

    case AccountActionType.SecurePhoneUnset:
      return `${i18n('Удалён телефон')} ${action.phoneUnset}`;

    case AccountActionType.SecurePhoneReplace:
      return `${i18n('Телефон')} ${action.phoneUnset} ${i18n('заменён на')} ${action.phoneSet}`;

    case AccountActionType.PhoneBind:
      return `${i18n('Добавлен телефон')} ${action.phoneBind}`;

    case AccountActionType.PhoneUnbind:
      return `${i18n('Удалён телефон')} ${action.phoneUnbind}`;

    case AccountActionType.Restore:
      return i18n('Восстановлен доступ к аккаунту');

    case AccountActionType.TotpDisabled:
      return i18n('Отключена двухфакторная аутентификация');

    case AccountActionType.AppPasswordEnabled:
      return i18n('Включены пароли приложений');

    case AccountActionType.AppPasswordsDisabled:
      return i18n('Отключены пароли приложений');

    case AccountActionType.TotpEnabled:
      return i18n('Включена двухфакторная аутентификация');

    case AccountActionType.TotpMigrated:
      return i18n('Заменено устройство для двухфакторной аутентификации');

    case AccountActionType.Login:
      if (action.authType === AccountAuthType.Web) {
        return i18n('Вход в аккаунт');
      }

      return `${i18n('Вход в аккаунт •')} ${AUTH_TYPE_TEXTS[action.authType]()}`;
  }
}
