import Image from 'next/image';
import { VFC, useCallback } from 'react';

import { Button, Text } from '@client/shared/ui-kit';
import { ArrowLongBack } from '@yandex/ui-icons';

import { i18n } from './i18n';
import protectionDangerImage from './assets/protection-danger.png';

import styles from './ItWasNotMe.module.css';

export enum ItWasNotMeEventType {
  CHANGE_PASSWORD = 'CHANGE_PASSWORD',
  FINE = 'FINE',
}

export interface ItWasNotMeEvent {
  type: ItWasNotMeEventType;
}

export interface ItWasNotMeProps {
  onActionEvent: (event: ItWasNotMeEvent) => void;
}

export const ItWasNotMe: VFC<ItWasNotMeProps> = (props) => {
  const { onActionEvent } = props;

  const handleChangePassword = useCallback(() => {
    onActionEvent({ type: ItWasNotMeEventType.CHANGE_PASSWORD });
  }, [onActionEvent]);

  const handleFine = useCallback(() => {
    onActionEvent({ type: ItWasNotMeEventType.FINE });
  }, [onActionEvent]);

  return (
    <div className={styles.root}>
      <div className={styles.image}>
        <Image src={protectionDangerImage} width={96} height={96} />
        <Button className={styles.backButton} size="l" onPress={handleFine}>
          <ArrowLongBack />
        </Button>
      </div>

      <div className={styles.content}>
        <Text as="div" variant="heading-l" weight="bold">
          {i18n('Что делать, если это не я?')}
        </Text>

        <Text as="p" variant="text-m-long">
          {i18n(
            'Возможно, кто-то посторонний получил доступ к вашему аккаунту. Чтобы защитить аккаунт, смените пароль и включите подтверждение входа',
          )}
        </Text>
      </div>

      <div className={styles.actions}>
        <Button variant="action" size="xl" onPress={handleChangePassword}>
          {i18n('Сменить пароль')}
        </Button>

        <Button variant="clear" size="xl" onPress={handleFine}>
          {i18n('Спасибо, всё в порядке')}
        </Button>
      </div>
    </div>
  );
};
