import { VFC } from 'react';

import { Text } from '@client/shared/ui-kit';
import { AccountChangedField } from '@shared/types/account';

import { i18n } from './i18n';

import styles from './PersonalFields.module.css';

const FIELDS_TEXTS: Record<string, () => string> = {
  city: () => i18n('город'),
  country: () => i18n('страна'),
  tz: () => i18n('часовой пояс'),
  firstname: () => i18n('имя'),
  lastname: () => i18n('фамилия'),
  birthday: () => i18n('дата рождения'),
  sex: () => i18n('пол'),
  display_name: () => i18n('имя на Яндексе'),
};

const GENDER_TEXTS: Record<string, () => string> = {
  1: () => i18n('мужской'),
  2: () => i18n('женский'),
};

export interface PersonalFieldsProps {
  fields: AccountChangedField[];
}

export const PersonalFields: VFC<PersonalFieldsProps> = (props) => {
  const { fields } = props;

  return (
    <span>
      <Text color="primary">{i18n('Что изменилось:')}</Text>
      <ul className={styles.list}>
        {fields.map((field) => (
          <Text as="li" key={field.key} color="primary">
            {FIELDS_TEXTS[field.key]()}: {formatValue(field.key, field.value)}
          </Text>
        ))}
      </ul>
    </span>
  );
};

function formatValue(key: string, value: string | null) {
  if (!value) {
    return null;
  }

  if (key === 'sex') {
    return GENDER_TEXTS[value]();
  }

  return value;
}
