import { FC } from 'react';

import { Grid, Skeleton, Text } from '@client/shared/ui-kit';

import { i18n } from './i18n';

import styles from './AccountActionsSkeleton.module.css';

export const AccountActionsSkeleton: FC = () => {
  const content = Array.from({ length: 3 }, (_, index) => {
    return (
      <Skeleton
        key={index}
        backgroundColor="var(--id-color-decor-neutral-50)"
        width="100%"
        height="76"
      >
        <rect height="100%" width="100%" rx="24" ry="24" />
      </Skeleton>
    );
  });

  return (
    <Grid className={styles.root}>
      <Text as="div" variant="text-l" color="secondary">
        {i18n('Секунду, сейчас загрузим...')}
      </Text>
      <Grid className={styles.actions}>{content}</Grid>
    </Grid>
  );
};
