import React from 'react';

import { withHydrate } from '@client/shared/libs/mobx-next';
import { Provider } from '@client/shared/libs/mobx-next';
import { SectionStack } from '@client/shared/ui-kit';
import { Meta } from '@storybook/react';

import { AccountActions } from '../AccountActions';
import * as data from './__mock__';

export default {
  title: 'Hermione/AccountActions',
  argTypes: {
    data: {
      control: 'select',
      options: Object.keys(data),
      mapping: data,
    },
  },
  parameters: {
    date: new Date(1655909058844),
  },
} as Meta;

const styles = `
  body {
    padding: 0 !important;
  }

  ::-webkit-scrollbar {
    display: none !important;
    width: 0 !important;
    background-color: transparent !important;
  }

  [data-testid='skeleton'] [role='presentation'] {
    fill: var(--id-color-decor-neutral-50) !important;
  }
`;

interface DefaultStoryArgs {
  data: typeof data[keyof typeof data];
}

export const Default = withHydrate((args: DefaultStoryArgs) => {
  return (
    <>
      <style>{styles}</style>
      <Provider value={args.data || data.EMPTY_DATA}>
        <SectionStack>
          <AccountActions />
        </SectionStack>
      </Provider>
    </>
  );
});
