import { AccountAction } from '@shared/types/account';
import { differenceInCalendarDays } from '@use-platform/react/libs/date';

import { i18n } from './i18n';

interface GroupedActions {
  title: string;
  actions: AccountAction[];
}

export function groupByDate(actions: AccountAction[]) {
  const today: GroupedActions = { title: i18n('Сегодня'), actions: [] };
  const week: GroupedActions = { title: i18n('В течение недели'), actions: [] };
  const month: GroupedActions = { title: i18n('Больше недели назад'), actions: [] };
  const halfYear: GroupedActions = { title: i18n('Больше месяца назад'), actions: [] };

  const now = Date.now();

  for (const action of actions) {
    const dayDiff = differenceInCalendarDays(now, action.timestamp);

    if (dayDiff <= 0) {
      today.actions.push(action);
    } else if (dayDiff <= 7) {
      week.actions.push(action);
    } else if (dayDiff <= 30) {
      month.actions.push(action);
    } else {
      halfYear.actions.push(action);
    }
  }

  return [today, week, month, halfYear].filter((group) => group.actions.length > 0);
}
