import { VFC } from 'react';

import { Clock } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { List, ListItemLink, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export const Activity: VFC = () => {
  return (
    <Section>
      <Section.Title anchor="activity">{i18n('Активность')}</Section.Title>
      <Section.Description>{i18n('События в аккаунте за 180 дней')}</Section.Description>
      <List>
        <ListItemLink
          {...logProps('listitem-link.activity')}
          href="/security/activity"
          icon={<Clock />}
          text={i18n('История активности')}
        />
      </List>
    </Section>
  );
};
