import { VFC } from 'react';

import { InsecureAuthHint } from '@client/entities/InsecureAuthHint';
import { AuthType, useAuthTypesQuery } from '@client/shared/api/graphql';
import { Notification } from '@client/shared/icons';
import { List, ListItemRadio, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';
import { PasswordAndSmsItem, PasswordAndSmsSwitch, PasswordOnlyItem, YandexKeyItem } from './ui';

export const AuthTypes: VFC = () => {
  const { data, loading, error } = useAuthTypesQuery();
  const { authType = null, phones } = data?.account || {};
  const primaryPhone = phones?.find((phone) => phone.isPrimary);

  if (error) {
    return null;
  }

  return (
    <Section>
      <Section.Title isHeading>
        {i18n('Способ входа', {
          context: 'Заголовок раздела с различными способами входа в аккаунт',
        })}
      </Section.Title>
      <Section.Description>
        {i18n('От выбранного способа зависит защита аккаунта')}
      </Section.Description>

      {!loading && authType === null && <InsecureAuthHint type="external-social" />}

      <List>
        <PasswordAndSmsItem
          authType={authType}
          text={i18n('Пароль + смс')}
          description={i18n('Вход с паролем и коротким кодом из смс или пуша')}
        />

        {authType === AuthType.SmsOnly && (
          <ListItemRadio
            icon={<Notification />}
            text={i18n('Код из смс')}
            description={i18n('Короткий код из смс или пуша')}
            isChecked={authType === AuthType.SmsOnly}
          />
        )}

        <YandexKeyItem
          authType={authType}
          text={i18n('Яндекс Ключ')}
          description={i18n('Защищённое приложение для авторизации')}
        />

        <PasswordOnlyItem
          authType={authType}
          text={i18n('Обычный пароль')}
          description={i18n('Пароль должен быть сложным и уникальным')}
        />
      </List>

      {!loading && <PasswordAndSmsSwitch number={primaryPhone?.number} authType={authType} />}
    </Section>
  );
};
