import { VFC, useCallback } from 'react';

import shieldBrokenSrc from '@client/shared/assets/shield-broken.png';
import { Button, CardTemplate, Dialog, ImageIcon, Text } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export enum LowerProtectionAlertEventType {
  CONTINUE,
  CANCEL,
}

export interface LowerProtectionAlertEvent {
  type: LowerProtectionAlertEventType;
}

export type LowerProtectionAlertProps = {
  visible: boolean;
  onAction: (event: LowerProtectionAlertEvent) => void;
};

export const LowerProtectionAlert: VFC<LowerProtectionAlertProps> = (props) => {
  const { visible, onAction } = props;

  const handleClose = useCallback(() => {
    onAction({ type: LowerProtectionAlertEventType.CANCEL });
  }, [onAction]);

  const handleContinue = useCallback(() => {
    onAction({ type: LowerProtectionAlertEventType.CONTINUE });
  }, [onAction]);

  return (
    <Dialog visible={visible} onClose={handleClose}>
      <CardTemplate>
        <CardTemplate.Media>
          <ImageIcon src={shieldBrokenSrc} size={120} />
        </CardTemplate.Media>

        <CardTemplate.Content align="center">
          <Text variant="heading-l" weight="bold">
            {i18n('Это действие понизит защиту.')}
            <br />
            {i18n('Точно продолжить?')}
          </Text>
        </CardTemplate.Content>

        <CardTemplate.Actions>
          <Button variant="default" size="xl" onPress={handleContinue}>
            {i18n('Продолжить')}
          </Button>
          <Button variant="clear" size="xl" onPress={handleClose}>
            {i18n('Оставить всё как есть')}
          </Button>
        </CardTemplate.Actions>
      </CardTemplate>
    </Dialog>
  );
};
