import { useMemo } from 'react';

import { useCurrentUrl, usePassportPaths } from '@client/shared/paths';

export interface UseUpgradeAccountUrlProps {
  retpath?: string;
}

export function useUpgradeAccountUrl(props: UseUpgradeAccountUrlProps = {}) {
  const currentUrl = useCurrentUrl();
  const passportPaths = usePassportPaths();
  const retpath = props.retpath ?? currentUrl.href;

  const upgradeAccountUrl = useMemo(() => {
    const url = new URL(passportPaths.upgradeAccount);

    url.searchParams.set('origin', 'profile_loginmethod');
    url.searchParams.set('retpath', retpath);

    return url.href;
  }, [passportPaths.upgradeAccount, retpath]);

  return upgradeAccountUrl;
}
