import { useMemo } from 'react';

import { useCurrentUrl, usePassportPaths } from '@client/shared/paths';

export interface UseYandexKeyUrlsProps {
  backpath?: string;
  retpath?: string;
}

export function useYandexKeyUrls(props: UseYandexKeyUrlsProps = {}) {
  const { retpath } = props;
  const currentUrl = useCurrentUrl();
  const passportPaths = usePassportPaths();
  const backpath = props.backpath ?? currentUrl.href;

  const enable = useMemo(() => {
    const url = new URL(passportPaths.yandexKeyEnable);

    url.searchParams.set('origin', 'profile_loginmethod');
    url.searchParams.set('backpath', backpath);

    if (retpath) {
      url.searchParams.set('retpath', retpath);
    }

    return url.href;
  }, [passportPaths.yandexKeyEnable, backpath, retpath]);

  const disable = useMemo(() => {
    const url = new URL(passportPaths.yandexKeyDisable);

    url.searchParams.set('origin', 'profile_loginmethod');
    url.searchParams.set('backpath', backpath);

    if (retpath) {
      url.searchParams.set('retpath', retpath);
    }

    return url.href;
  }, [passportPaths.yandexKeyDisable, backpath, retpath]);

  return { enable, disable };
}
