import { createNotifier } from '@client/shared/libs/notifications';

import { i18n } from './i18n';

const notifier = createNotifier();

export const AuthTypesNotifier = {
  authTypeChanged: notifier.success.prepend(() => {
    return i18n('Поменялся способ входа');
  }),
  internal: notifier.error.prepend(() => {
    return i18n('Что-то пошло не так, попробуйте ещё раз позже');
  }),
};
