import { VFC, useCallback } from 'react';

import { AuthType } from '@client/shared/api/graphql';
import { KeyNotification } from '@client/shared/icons';
import { useCurrentUrl } from '@client/shared/paths';
import { ListItemRadio } from '@client/shared/ui-kit';

import { useUpgradeAccountUrl, useYandexKeyUrls } from '../../libs';
import { PasswordAndSmsModal } from '../../model';

export interface PasswordAndSmsItemProps {
  text: string;
  description: string;
  authType: AuthType | null;
}

export const PasswordAndSmsItem: VFC<PasswordAndSmsItemProps> = (props) => {
  const { authType, text, description } = props;
  const currentUrlWithDialog = useCurrentUrl();

  currentUrlWithDialog.searchParams.set('dialog', PasswordAndSmsModal.DIALOG_KEY);

  const upgradeAccountUrl = useUpgradeAccountUrl({ retpath: currentUrlWithDialog.href });
  const yandexKeyUrls = useYandexKeyUrls({ retpath: currentUrlWithDialog.href });

  const handlePress = useCallback(() => {
    switch (authType) {
      case AuthType.PasswordAndSms:
        return;

      case AuthType.PasswordOnly:
        PasswordAndSmsModal.show();
        break;

      case AuthType.YandexKey:
        window.location.href = yandexKeyUrls.disable;
        break;

      case AuthType.SmsOnly:
      case null:
        window.location.href = upgradeAccountUrl;
        break;
    }
  }, [authType, upgradeAccountUrl, yandexKeyUrls.disable]);

  return (
    <ListItemRadio
      icon={<KeyNotification />}
      text={text}
      description={description}
      isChecked={authType === AuthType.PasswordAndSms}
      onPress={handlePress}
    />
  );
};
