import { useStore } from 'effector-react';
import { useEvent } from 'effector-react';
import { VFC, useCallback } from 'react';

import {
  BindPrimaryPhone,
  BindPrimaryPhonePayload,
} from '@client/features/phone/bind-primary-phone';
import {
  ConfirmPhoneBySms,
  ConfirmPhoneBySmsPayload,
} from '@client/features/phone/confirm-phone-by-sms';
import {
  AuthType,
  useDisableLoginWithPasswordAndSmsMutation,
  useEnableLoginWithPasswordAndSmsMutation,
} from '@client/shared/api/graphql';

import { PasswordAndSmsModal } from '../../model';
import { AuthTypesNotifier } from '../../notifier';

export interface PasswordAndSmsSwitchProps {
  authType: AuthType | null;
  number?: string;
}

export const PasswordAndSmsSwitch: VFC<PasswordAndSmsSwitchProps> = (props) => {
  const { number, authType } = props;
  const isVisible = useStore(PasswordAndSmsModal.$isVisible);

  const [enable] = useEnableLoginWithPasswordAndSmsMutation();
  const [disable] = useDisableLoginWithPasswordAndSmsMutation();

  const handleComplete = useCallback(
    (input: BindPrimaryPhonePayload | ConfirmPhoneBySmsPayload) => {
      const enabled = authType === AuthType.PasswordAndSms;
      const toggle = enabled ? disable : enable;

      PasswordAndSmsModal.hide();

      toggle({
        variables: { input },
        onCompleted: (data) => {
          const { response } = data;

          if (response.__typename === 'ToggleLoginWithPasswordAndSmsPayload') {
            AuthTypesNotifier.authTypeChanged();
          } else {
            AuthTypesNotifier.internal();
          }
        },
      });
    },
    [authType, disable, enable],
  );

  const handleClose = useEvent(PasswordAndSmsModal.hide);

  if (number) {
    return (
      <ConfirmPhoneBySms
        visible={isVisible}
        number={number}
        onCompleted={handleComplete}
        onClose={handleClose}
      />
    );
  }

  return (
    <BindPrimaryPhone visible={isVisible} onCompleted={handleComplete} onClose={handleClose} />
  );
};
