import { VFC, useCallback } from 'react';

import { AuthType } from '@client/shared/api/graphql';
import { YandexKey } from '@client/shared/icons/colored';
import { useCurrentUrl } from '@client/shared/paths';
import { ListItemRadio } from '@client/shared/ui-kit';

import { useUpgradeAccountUrl, useYandexKeyUrls } from '../../libs';

export interface YandexKeyItemProps {
  text: string;
  description: string;
  authType: AuthType | null;
}

export const YandexKeyItem: VFC<YandexKeyItemProps> = (props) => {
  const { authType, text, description } = props;
  const currentUrl = useCurrentUrl();
  const upgradeAccountUrl = useUpgradeAccountUrl();
  const yandexKeyUrls = useYandexKeyUrls({ retpath: currentUrl.href });

  const handlePress = useCallback(() => {
    switch (authType) {
      case AuthType.YandexKey:
        return;

      case AuthType.PasswordOnly:
      case AuthType.PasswordAndSms:
        window.location.href = yandexKeyUrls.enable;
        break;

      default:
        window.location.href = upgradeAccountUrl;
    }
  }, [authType, upgradeAccountUrl, yandexKeyUrls.enable]);

  return (
    <ListItemRadio
      icon={<YandexKey />}
      text={text}
      description={description}
      isChecked={authType === AuthType.YandexKey}
      onPress={handlePress}
    />
  );
};
