import {
  CreateBindingDocument,
  CreateBindingMutation,
  CreateBindingMutationVariables,
  UnbindBankCardDocument,
  UnbindBankCardMutation,
  UnbindBankCardMutationVariables,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';
import { AccountBindBankCardInput } from '@server/graphql-schema';

export async function unbindBankCard(cardId: string) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<UnbindBankCardMutation, UnbindBankCardMutationVariables>({
    mutation: UnbindBankCardDocument,
    variables: { cardId },
  });

  if (!result.data) {
    return false;
  }

  return Promise.resolve(result.data);
}

export async function createBinding(input: AccountBindBankCardInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<CreateBindingMutation, CreateBindingMutationVariables>({
    mutation: CreateBindingDocument,
    variables: { input },
  });

  if (result.data?.accountBindBankCard.status === 'error') {
    return Promise.resolve(undefined);
  }

  return Promise.resolve(result.data?.accountBindBankCard.url);
}
