import 'focus-visible';
import { VFC, useRef } from 'react';

import { Add } from '@client/shared/icons';
import { PressEventProps, mergeProps, useButton, useHover } from '@use-platform/react';

import { i18n } from './i18n';

import styles from './AddCard.module.css';

interface AddCardProps extends PressEventProps {
  disabled?: boolean;
}

export const AddCard: VFC<AddCardProps> = (props) => {
  const buttonRef = useRef<HTMLButtonElement>(null);
  const { buttonProps, isPressed } = useButton(props, buttonRef);
  const { isHovered, hoverProps } = useHover({ disabled: props.disabled });

  return (
    <button
      className={styles.container}
      {...mergeProps(buttonProps, hoverProps)}
      ref={buttonRef}
      data-hovered={isHovered}
      data-pressed={isPressed}
      {...props}
    >
      <Add size={16} />
      <div>
        <div className={styles.text}>{i18n('Добавить карту в Pay')}</div>
      </div>
    </button>
  );
};
