/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import cx from 'classnames';
import { useCallback, useEffect, useRef, useState } from 'react';

import { useEnvContext } from '@client/shared/libs/env';
import { Modal, Section, SectionStack, Spin } from '@client/shared/ui-kit';

import { createBinding } from '../../api';
import { useTrustSdk } from '../../trust';

import styles from './CardBindingForm.module.css';

interface ICardBindingForm {
  visible: boolean;
  trackId: string;
  onClose(): void;
  onSuccess(): void;
}

export const CardBindingForm: React.FC<ICardBindingForm> = ({
  visible,
  onClose,
  onSuccess,
  trackId,
}) => {
  const {
    ua: { isTouch },
    tld,
    language,
  } = useEnvContext();
  const iframeContainerRef = useRef<HTMLDivElement>(null);
  const [initedBindedForm, setInited] = useState(false);

  const onSuccessBind = useCallback(() => {
    onSuccess();
    setInited(false);
  }, [onSuccess]);

  const { initBindCard, isError } = useTrustSdk({
    onClose,
    onSuccess: onSuccessBind,
    width: '100%',
    height: '100%',
  });

  useEffect(() => {
    if (visible && iframeContainerRef && !initedBindedForm) {
      createBinding({
        trackId,
        lang: language.id,
        domainSfx: tld,
        templateTag: isTouch ? 'mobile/form' : 'desktop/form',
        returnPath: window.location.href,
      }).then((res) => {
        setInited(true);
        initBindCard(iframeContainerRef, res);
      });
    }
  }, [
    iframeContainerRef,
    initBindCard,
    visible,
    initedBindedForm,
    trackId,
    language.id,
    tld,
    isTouch,
  ]);

  return (
    <Modal className={cx(styles.dialog)} visible={visible} onClose={onClose}>
      <SectionStack>
        <Section>
          <Section.Title>Привязка новой карты</Section.Title>
          <Section.Content className={styles.content}>
            {isError ? (
              <div>Error</div>
            ) : (
              <div
                id="cardbindingform"
                className={cx(styles.iframe, { [styles.iframeLoading]: !initedBindedForm })}
                ref={iframeContainerRef}
              >
                {!initedBindedForm && <Spin view="default" progress size="l" />}
              </div>
            )}
          </Section.Content>
        </Section>
      </SectionStack>
    </Modal>
  );
};
