import { BankCard as BankCardData } from '@client/shared/api/graphql';
import { TrashOutline } from '@client/shared/icons';
import { BankCard, Button, Dialog, ListItem } from '@client/shared/ui-kit';

import { dataToBankCardProps } from '../../helpers';
import { i18n } from './i18n';

import styles from './CardSettings.module.css';

interface ICardSettings {
  cardData: BankCardData | null;
  visible: boolean;
  onClose(): void;
  onDeleteClick(): void;
}

export const CardSettings: React.FC<ICardSettings> = ({
  cardData,
  visible,
  onClose,
  onDeleteClick,
}) => {
  if (!cardData) {
    return null;
  }

  return (
    <Dialog visible={visible} onClose={onClose} className={styles.dialog}>
      <BankCard
        className={styles.card}
        key={cardData.id}
        {...dataToBankCardProps(cardData)}
        disabled
      />
      <div className={styles.shadow} />
      <ListItem
        icon={<TrashOutline />}
        text={i18n('Удалить карту')}
        plateColor="warning"
        onClick={onDeleteClick}
        tabIndex={0}
      />
      <Button className={styles.close} onPress={onClose} size="xl">
        {i18n('Закрыть')}
      </Button>
    </Dialog>
  );
};
