import { VFC } from 'react';

import { Carousel, CarouselItem, Skeleton } from '@client/shared/ui-kit';

const BankCardSkelton = () => (
  <Skeleton height="90" width="120">
    <rect height="100%" width="100%" rx="20" ry="20" />
  </Skeleton>
);

export const BankCardsWidgetSkeleton: VFC = () => (
  <Carousel>
    <CarouselItem>
      <BankCardSkelton />
    </CarouselItem>
    <CarouselItem>
      <BankCardSkelton />
    </CarouselItem>
    <CarouselItem>
      <BankCardSkelton />
    </CarouselItem>
    <CarouselItem>
      <BankCardSkelton />
    </CarouselItem>
  </Carousel>
);
