import { BankCard } from '@client/shared/api/graphql';
import { BankCardProps, BankCardType, CardBank, CardSystem } from '@client/shared/ui-kit';

import { BinToBank } from './bin';

export const dataToBankCardProps = (data: BankCard): BankCardProps => {
  return {
    paymentSystem: data.system.toLocaleLowerCase() as CardSystem,
    cardNumber: data.number.slice(-6),
    bankCardType: BankCardType.Default,
    bank: BinToBank[data.number.substring(0, 6)] || CardBank.Unknown,
  };
};
