import { VFC } from 'react';

import { useBonusCardsWidgetQuery } from '@client/shared/api/graphql';
import { useEnvContext } from '@client/shared/libs/env';
import { useAvatarsPath } from '@client/shared/paths';
import { YandexAppPromo } from '@client/shared/ui-kit/YandexAppPromo';

import { i18n } from './i18n';

import styles from './BonusCards.module.css';

export const BonusCards: VFC = () => {
  const { loading, data, error } = useBonusCardsWidgetQuery();
  const avatarsHost = useAvatarsPath();
  const {
    language,
    ua: { mobileOsFamily, isMobile },
  } = useEnvContext();

  if (loading || error || !data) {
    return null;
  }

  const { viewer } = data;

  return (
    <div className={styles.root}>
      <YandexAppPromo
        lang={language.id}
        usrImg={`${avatarsHost}/get-yapic/${viewer.avatarId}/islands-300`}
        title={i18n('Бонусные карты можно хранить в приложении Яндекс {logo}', { logo: '{logo}' })}
        installMessage={i18n('Установить приложение Яндекс')}
        description={i18n(
          'Чтобы добавить карту, откройте умную камеру и выберите режим Карты.{break}Чтобы показать карту на кассе, откройте в приложении свой профиль {avatar} и нажмите Бонусные карты.',
          {
            break: '{break}',
            avatar: '{avatar}',
          },
        )}
        device={isMobile ? mobileOsFamily : 'desktop'}
      />
    </div>
  );
};
