import React, { VFC } from 'react';

import { useEdadealData } from '@client/features/finance/api/store';
import { useEnvContext } from '@client/shared/libs/env';
import { Section } from '@client/shared/ui-kit';

import { EdadealHint } from './components/EdadealHint/EdadealHint';
import { HintSkeleton } from './components/HintSkeleton';
import { PlusHint } from './components/PlusHint';

import styles from './Cashback.module.css';

export const Cashback: VFC = () => {
  const {
    viewer: { havePlus, plusBalance },
  } = useEnvContext();
  const { data, isLoading, error } = useEdadealData();

  if (isLoading) {
    return (
      <div className={styles.content}>
        <HintSkeleton />
        <HintSkeleton />
      </div>
    );
  }

  if (error || !data) {
    return null;
  }

  const { amount: edadealAmount, hasBinding: hasEdadealBinding, url } = data;

  return (
    <Section>
      <Section.Title anchor="cashback">Кешбэк</Section.Title>
      <div className={styles.content}>
        <PlusHint havePlus={havePlus} balance={plusBalance} />

        <EdadealHint url={url} hasBinding={hasEdadealBinding} balance={edadealAmount ?? 0} />
      </div>
    </Section>
  );
};
