import { FC } from 'react';

import { useEdadealConnectUrl } from '@client/features/finance/hooks';
import { Text } from '@client/shared/ui-kit';
import { formatCurrency } from '@shared/helpers';

import { Hint } from '../Hint';
import coinsImage from './assets/coins.png';

import styles from './EdadealHint.module.css';

export interface EdadealHintProps {
  url: string;
  hasBinding: boolean;
  balance: number;
}

export const EdadealHint: FC<EdadealHintProps> = (props) => {
  const { url, balance, hasBinding } = props;
  const edadealConnectUrl = useEdadealConnectUrl({ url });

  if (hasBinding && balance > 0) {
    return (
      <Hint
        text="Кешбэк за покупки"
        before={<img src={coinsImage.src} className={styles.hintImage} />}
        after={
          <Text variant="text-m" weight="medium">
            {`${balance} ${formatCurrency('RUB')}`}
          </Text>
        }
        href="https://edadeal.ru/cashbacks"
        target="_blank"
        background="edadeal"
      />
    );
  }

  if (!hasBinding) {
    return (
      <Hint
        text="Мои чеки: кешбэк за покупки в магазинах"
        before={<img src={coinsImage.src} className={styles.hintImage} />}
        link={
          <Text variant="text-m" weight="medium" className={styles.edadealText}>
            Хочу кэшбэк
          </Text>
        }
        href={edadealConnectUrl}
        target="_blank"
        background="edadeal"
      />
    );
  }

  return null;
};
