import { FC } from 'react';

import { useExternalPaths } from '@client/shared/paths';
import { Text } from '@client/shared/ui-kit';

import { Hint } from '../Hint';
import plusImage from './assets/plus.png';

import styles from './PlusHint.module.css';

export interface PlusHintProps {
  havePlus: boolean;
  balance: string;
}

export const PlusHint: FC<PlusHintProps> = (props) => {
  const { havePlus, balance } = props;

  const externalPaths = useExternalPaths();
  const href = `${
    externalPaths.plus
  }/?utm_source=yandexid&utm_medium=payment_history&utm_campaign=${
    havePlus ? 'yandexid_plus' : 'yandexid_no_plus'
  }`;

  if (havePlus) {
    return (
      <Hint
        text="Кешбэк за покупки баллами Плюса"
        before={<img src={plusImage.src} className={styles.hintImage} />}
        after={
          <Text variant="text-m" weight="medium" className={styles.plusText}>
            {balance}
          </Text>
        }
        href={href}
        target="_blank"
      />
    );
  }

  return (
    <Hint
      text="Яндекс Плюс: Фильмы, музыка и кешбэк баллами"
      before={<img src={plusImage.src} className={styles.hintImage} />}
      link={
        <Text variant="text-m" weight="medium" className={styles.plusText}>
          30 дней бесплатно
        </Text>
      }
      href={href}
      target="_blank"
    />
  );
};
