import { EmailType, useContactsQuery } from '@client/shared/api/graphql';
import { useMappedQuery } from '@client/shared/libs/apollo';

export function useContactsData() {
  return useMappedQuery(useContactsQuery, ({ account, externalAccounts }) => {
    const { phones, emails } = account;

    const defaultPhone = phones.find((phone) => phone.isPrimary);
    const additionalPhone = phones.find((phone) => !phone.isPrimary);
    const defaultEmail = emails.find((email) => email.isPrimary);
    const hasRecoveryEmail = emails.some(
      (email) => email.type !== EmailType.Native && !email.isPrimary,
    );

    let entryToRequest: 'defaultPhone' | 'defaultEmail' | null = null;

    if (!defaultPhone) {
      entryToRequest = 'defaultPhone';
    } else if (!defaultEmail) {
      entryToRequest = 'defaultEmail';
    }

    return {
      additionalPhone,
      defaultEmail,
      defaultPhone,
      entryToRequest,
      externalAccounts,
      hasRecoveryEmail,
    };
  });
}
