import React, { VFC } from 'react';

import { DataErase, Key, Mail, Percent, TrashOutline } from '@client/shared/icons';
import { Alisa } from '@client/shared/icons/colored';
import { useEnvContext } from '@client/shared/libs/env';
import { logProps } from '@client/shared/libs/metrika';
import { useIdPaths, usePassportPaths, useYandexAppPaths } from '@client/shared/paths';
import { List, ListItemLink, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export const DataManagement: VFC = () => {
  const passportPaths = usePassportPaths();
  const idPaths = useIdPaths();
  const yandexAppPaths = useYandexAppPaths();
  const {
    ua: { isYandexApp, mobileOsFamily },
    uiFlags: { additionalNavigation },
  } = useEnvContext();

  return (
    <Section>
      <Section.Title anchor="data-management">
        {i18n('Управление данными', { context: 'Заголовок блока управление данными в ЛК' })}
      </Section.Title>
      <List>
        <ListItemLink
          icon={<Key />}
          text={i18n('Пароли сайтов', {
            context: 'Текст ссылки на раздел промо-страницы Пароли сайтов',
          })}
          description={i18n('Только в приложении Яндекс', {
            context: 'Описание ссылки на промо-страницы',
          })}
          href={
            isYandexApp && mobileOsFamily && additionalNavigation
              ? yandexAppPaths.websitesPasswords[mobileOsFamily]
              : idPaths.passwords
          }
          {...logProps('listitem-link.websites-passwords')}
        />
        <ListItemLink
          icon={<Percent />}
          text={i18n('Бонусные карты', {
            context: 'Текст ссылки на раздел промо-страницы Бонусные карты',
          })}
          description={i18n('Только в приложении Яндекс', {
            context: 'Описание ссылки на промо-страницы',
          })}
          href={
            isYandexApp && mobileOsFamily && additionalNavigation
              ? yandexAppPaths.bonusCards[mobileOsFamily]
              : idPaths.bonus
          }
          {...logProps('listitem-link.bonus-cards')}
        />
        <ListItemLink
          icon={<Alisa />}
          text={i18n('Данные для Алисы', {
            context: 'Текст ссылки на раздел управления данными для Алисы',
          })}
          href={passportPaths.aliceSettings}
          {...logProps('listitem-link.alice-data')}
        />
        <ListItemLink
          icon={<Mail />}
          text={i18n('Проморассылки', { context: 'Текст ссылки на управление проморассылками' })}
          href={passportPaths.promoMailing}
          {...logProps('listitem-link.promo-mailing')}
        />
        <ListItemLink
          icon={<DataErase />}
          text={i18n('Данные на сервисах', {
            context:
              'Текст ссылки на раздел управления данными, которые предоставляются другим сервисам',
          })}
          href={passportPaths.dataManagement}
          {...logProps('listitem-link.services-data')}
        />
        <ListItemLink
          icon={<TrashOutline />}
          plateColor="warning"
          text={i18n('Удалить аккаунт', {
            context: 'Текст ссылки на запуск процесса удаления аккаунта',
          })}
          href={passportPaths.deleteProfile}
          {...logProps('listitem-link.delete-profile')}
        />
      </List>
    </Section>
  );
};
