import { VFC } from 'react';

import { PlusOutline } from '@client/shared/icons';
import { Button } from '@client/shared/ui-kit';

import styles from './AddDocumentButton.module.css';

interface AddDocumentButtonProps {
  onPress: () => void;
}

export const AddDocumentButton: VFC<AddDocumentButtonProps> = (props) => {
  const { onPress } = props;

  return (
    <div className={styles.root}>
      <Button
        className={styles.button}
        variant="default"
        size="xl"
        before={<PlusOutline />}
        onPress={onPress}
      >
        Добавить документ
      </Button>
    </div>
  );
};
