import { VFC } from 'react';

import {
  BirthCertificateThumb,
  DriverLicenseThumb,
  InnThumb,
  InternationalIdThumb,
  MedicalInsuranceThumb,
  NationalIdThumb,
  SnilsThumb,
  VehicleRegistrationCertificateThumb,
  VoluntaryMedicalInsuranceThumb,
} from '@client/features/document-editor';
import { DocumentSection, DocumentType } from '@client/shared/api/graphql';
import { Carousel, CarouselItem, Text } from '@client/shared/ui-kit';

import { SECTION_TITLE_MAP } from '../../constants';
import { ThumbItem } from '../../types';

import styles from './ThumbList.module.css';

interface ThumbListProps {
  section: DocumentSection;
  documents: ThumbItem[];
}

export const ThumbList: VFC<ThumbListProps> = (props) => {
  const { section, documents } = props;

  return (
    <div className={styles.root}>
      <Text as="h3" variant="heading-m">
        {SECTION_TITLE_MAP[section].title}
      </Text>
      <Carousel>
        {documents.map((document) => (
          <CarouselItem key={document.id}>
            {document.type === DocumentType.BirthCertificate && (
              <BirthCertificateThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.DriverLicense && (
              <DriverLicenseThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.Inn && (
              <InnThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.InternationalId && (
              <InternationalIdThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.NationalId && (
              <NationalIdThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.MedicalInsurance && (
              <MedicalInsuranceThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.Snils && (
              <SnilsThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.VoluntaryMedicalInsurance && (
              <VoluntaryMedicalInsuranceThumb
                firstName={document.firstName}
                lastName={document.lastName}
                documentId={document.id}
              />
            )}
            {document.type === DocumentType.VehicleRegistrationCertificate && (
              <VehicleRegistrationCertificateThumb
                model={document.model}
                documentId={document.id}
              />
            )}
          </CarouselItem>
        ))}
      </Carousel>
    </div>
  );
};
