import { DocumentSection, DocumentType } from '@client/shared/api/graphql';

import { ThumbItem } from './types';

export function splitDocumentsIntoSections(documents: ThumbItem[]) {
  const personal = documents.filter((document) => document.section === DocumentSection.Personal);
  const transport = documents.filter((document) => document.section === DocumentSection.Transport);
  const health = documents.filter((document) => document.section === DocumentSection.Health);
  const finance = documents.filter((document) => document.section === DocumentSection.Finance);

  const splitedDocuments = [];

  if (personal.length !== 0) {
    splitedDocuments.push({
      section: DocumentSection.Personal,
      documents: personal.sort((first, second) => {
        if (first.type === DocumentType.NationalId) {
          return -1;
        }
        if (second.type === DocumentType.NationalId) {
          return 1;
        }
        if (first.type === DocumentType.InternationalId) {
          return -1;
        }
        if (second.type === DocumentType.InternationalId) {
          return 1;
        }

        return 0;
      }),
    });
  }
  if (transport.length !== 0) {
    splitedDocuments.push({
      section: DocumentSection.Transport,
      documents: transport.sort((first, second) => {
        if (first.type === DocumentType.DriverLicense) {
          return -1;
        }
        if (second.type === DocumentType.DriverLicense) {
          return 1;
        }

        return 0;
      }),
    });
  }
  if (health.length !== 0) {
    splitedDocuments.push({
      section: DocumentSection.Health,
      documents: health.sort((first, second) => {
        if (first.type === DocumentType.MedicalInsurance) {
          return -1;
        }
        if (second.type === DocumentType.VoluntaryMedicalInsurance) {
          return 1;
        }

        return 0;
      }),
    });
  }
  if (finance.length !== 0) {
    splitedDocuments.push({
      section: DocumentSection.Finance,
      documents: finance.sort((first, second) => {
        if (first.type === DocumentType.Inn) {
          return -1;
        }
        if (second.type === DocumentType.Inn) {
          return 1;
        }

        return 0;
      }),
    });
  }

  return splitedDocuments;
}
