import { useRouter } from 'next/router';
import { VFC, useCallback, useEffect, useState } from 'react';

import { useEdadealData } from '@client/features/finance/api/store';
import { useEnvContext } from '@client/shared/libs/env';
import { sendParams } from '@client/shared/libs/metrika';

import { EdadealPopup } from './components/EdadealPopup';

const ENTRIES = ['receipts-popup', 'receipts-popup-sc', 'receipts-popup-promo'];

export const EdadealConnect: VFC = () => {
  const { yenv } = useEnvContext();
  const router = useRouter();
  const [, hash] = router.asPath.split('#');
  const visible = ENTRIES.includes(hash);
  const { data, isLoading, error } = useEdadealData();
  const [iframeSrc, setIframeSrc] = useState<string | null>(null);

  const {
    ua: { isTouch },
  } = useEnvContext();

  const skipSetIframeSrc =
    isTouch || isLoading || Boolean(error) || data?.hasBinding || !data?.iframeSrc;

  useEffect(() => {
    if (skipSetIframeSrc) {
      return;
    }

    const iframeSrc =
      yenv === 'rc' && !router.query.useEdadealProd
        ? data.iframeSrc.replace('.edadeal.', '.edastage.')
        : data.iframeSrc;

    const urlObject = new URL(iframeSrc);

    urlObject.searchParams.append('referer', window.location.href);

    setIframeSrc(urlObject.href);
  }, [data?.iframeSrc, router.query.useEdadealProd, skipSetIframeSrc, yenv]);

  const onClosePopup = useCallback(() => {
    sendParams('edadeal-popup.close', { from: window.location.hash.slice(1) });
    router.push({ hash: undefined });
  }, [router]);

  const onSuccessConnect = useCallback(() => {
    sendParams('edadeal-popup.connect', { from: window.location.hash.slice(1) });
    onClosePopup();
    router.reload();
  }, [router, onClosePopup]);

  if (!iframeSrc) {
    return null;
  }

  return (
    <EdadealPopup
      onClose={onClosePopup}
      onSuccess={onSuccessConnect}
      visible={visible}
      iframeSrc={iframeSrc}
    />
  );
};
