import cx from 'classnames';
import { VFC, useCallback, useEffect, useRef, useState } from 'react';

import styles from './EdadealPopup.module.css';

interface EdadealPopupProps {
  iframeSrc: string;
  visible: boolean;
  onClose(): void;
  onSuccess(): void;
}

const EDADEAL_HOSTS = [
  'https://desktop.checks.edadeal.yandex.ru',
  'https://desktop.checks.edastage.yandex.ru',
];

export const EdadealPopup: VFC<EdadealPopupProps> = ({
  iframeSrc,
  onClose,
  visible,
  onSuccess,
}) => {
  const iframeRef = useRef<HTMLIFrameElement>(null);
  const [loaded, setLoaded] = useState(false);

  useEffect(() => {
    if (visible && iframeRef.current && loaded) {
      iframeRef.current.contentWindow?.postMessage('open', '*');
    }
  }, [visible, loaded]);

  const onMessage = useCallback(
    (event) => {
      if (!EDADEAL_HOSTS.includes(event.origin)) {
        return;
      }

      event.data === 'ready' && setLoaded(true);
      event.data === 'close' && onClose();
      event.data === 'boundToFns' && onSuccess();
    },
    [onClose, onSuccess],
  );

  useEffect(() => {
    window.addEventListener('message', onMessage);

    return () => {
      window.removeEventListener('message', onMessage);
    };
  }, []);

  return (
    <div className={cx(styles.root, { [styles.root_visible]: loaded && visible })}>
      <iframe
        ref={iframeRef}
        width="100%"
        height="100%"
        src={iframeSrc}
        frameBorder="0"
        referrerPolicy="unsafe-url"
      />
    </div>
  );
};
