import { AuthType } from '@client/shared/api/graphql';

import { i18n } from './i18n';

export function getPasswordUpdateDescription(lastPasswordUpdate: number) {
  // TODO: Использовал i18n plural для склонения.
  const currentDate = new Date().getTime();

  const diffTime = Math.abs(currentDate - lastPasswordUpdate);
  const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24));
  const diffMonths = Math.ceil(diffDays / 30);

  if (diffDays === 0) {
    return i18n('Обновлен сегодня');
  }

  if (diffDays < 30) {
    return i18n('Менялся {count} дней назад', { count: diffDays });
  }

  return i18n('Менялся {count} месяцев назад', { count: diffMonths });
}

export function getAuthTypeText(authType: AuthType | null) {
  if (authType === AuthType.YandexKey) {
    return i18n('Яндекс Ключ');
  }

  if (authType === AuthType.PasswordOnly) {
    return i18n('Обычный пароль');
  }

  if (authType === AuthType.PasswordAndSms) {
    return i18n('Пароль + смс');
  }

  if (authType === AuthType.SmsOnly) {
    return i18n('Код из смс');
  }

  return i18n('Сменить способ входа');
}
