import { VFC } from 'react';

import { useExternalAccessesQuery } from '@client/shared/api/graphql';
import { Allow, Keys, SocialProviders } from '@client/shared/icons';
import { usePassportPaths } from '@client/shared/paths';
import { List, ListItemLink, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export const ExternalAccesses: VFC = () => {
  const { data } = useExternalAccessesQuery();
  const passportPaths = usePassportPaths();
  const externalAccounts = data?.externalAccounts.length;

  return (
    <Section>
      <Section.Title anchor="external-accesses">{i18n('Доступ к вашим данным')}</Section.Title>
      <Section.Description>
        {i18n('Сайты и приложения, которым вы разрешили доступ к данным аккаунта')}
      </Section.Description>
      <List>
        <ListItemLink
          href={passportPaths.social}
          icon={<SocialProviders />}
          text={i18n('Внешние аккаунты')}
          description={i18n('ВК, ОК, Госуслуги, и т.д.')}
          counter={externalAccounts}
        />
        <ListItemLink
          href={passportPaths.devices}
          icon={<Allow />}
          text={i18n('Управлять доступами')}
        />
        <ListItemLink
          href={passportPaths.appPasswords}
          icon={<Keys />}
          text={i18n('Пароли приложений')}
        />
      </List>
    </Section>
  );
};
