import { VFC, useCallback } from 'react';

import { broker } from '@client/features/bind-external-account';
import {
  ExternalAccountProviderName,
  useExternalAccountProvidersWidgetQuery,
} from '@client/shared/api/graphql';

import { ProviderTile } from '../ProviderTile';
import { i18n } from './i18n';

import styles from './ProviderList.module.css';

function getProviderText(name: ExternalAccountProviderName) {
  const TEXTS: Record<ExternalAccountProviderName, string> = {
    [ExternalAccountProviderName.Vk]: i18n('ВК'),
    [ExternalAccountProviderName.Facebook]: i18n('Facebook'),
    [ExternalAccountProviderName.Twitter]: i18n('Twitter'),
    [ExternalAccountProviderName.Mailru]: i18n('Mail'),
    [ExternalAccountProviderName.Google]: i18n('Google'),
    [ExternalAccountProviderName.Odnoklassniki]: i18n('OK'),
    [ExternalAccountProviderName.Apple]: i18n('Apple'),
    [ExternalAccountProviderName.Esia]: i18n('ЕСИА'),
  };

  return TEXTS[name];
}

export const ProviderList: VFC = () => {
  const { data, error, loading } = useExternalAccountProvidersWidgetQuery();

  const handleBindAccount = useCallback((name: ExternalAccountProviderName) => {
    broker.bindByProviderName(name);
  }, []);

  if (loading || error || !data) {
    return null;
  }

  const { providers } = data;

  return (
    <div className={styles.root}>
      {providers.map((provider) => (
        <ProviderTile key={provider.id} name={provider.name} onBindAccount={handleBindAccount}>
          {getProviderText(provider.name)}
        </ProviderTile>
      ))}
    </div>
  );
};
