import { FC, useCallback } from 'react';

import { ExternalProviderIcon } from '@client/entities/external-provider-icon';
import { ExternalAccountProviderName } from '@client/shared/api/graphql';
import { Button, Text } from '@client/shared/ui-kit';

import styles from './ProviderTile.module.css';

export interface ProviderTileProps {
  name: ExternalAccountProviderName;
  onBindAccount: (name: ExternalAccountProviderName) => void;
}

export const ProviderTile: FC<ProviderTileProps> = (props) => {
  const { name, onBindAccount, children } = props;

  const handleBindAccount = useCallback(() => {
    onBindAccount(name);
  }, [onBindAccount, name]);

  return (
    <div className={styles.root}>
      <Button className={styles.button} variant="default" onPress={handleBindAccount}>
        <ExternalProviderIcon name={name} />
      </Button>
      <Text className={styles.text} variant="text-s">
        {children}
      </Text>
    </div>
  );
};
