import { VFC } from 'react';

import { Link, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';
import { AccountList } from './ui';

export const ExternalAccounts: VFC = () => {
  return (
    <Section>
      <Section.Title isHeading>{i18n('Внешние аккаунты')}</Section.Title>

      <Section.Description>
        {i18n('С помощью привязанных аккаунтов можно заполнить данные профиля и входить в Яндекс.')}
        &nbsp;
        <Link key="link" href="https://yandex.ru/support/id/social.html" target="_blank">
          {i18n('Узнать больше')}
        </Link>
      </Section.Description>

      <AccountList />
    </Section>
  );
};
