/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import React, { VFC } from 'react';

import { Link, Login } from '@client/shared/icons';
import { List, ListItem, ListItemToggle } from '@client/shared/ui-kit';

import styles from './AccountActionList.module.css';

export interface AccountActionListProps {
  allowAuth: boolean;
}

export const AccountActionList: VFC<AccountActionListProps> = (props) => {
  const { allowAuth } = props;

  return (
    <List className={styles.root}>
      <ListItemToggle
        icon={<Login />}
        text="Входить в Яндекс этим аккаунтом"
        isChecked={allowAuth}
        disabled={false}
      />

      <ListItem icon={<Link />} text="Отвязать аккаунт" />
    </List>
  );
};
