/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useCallback, useState } from 'react';

import { ExternalProviderIcon } from '@client/entities/external-provider-icon';
import { ExternalAccountProviderName } from '@client/shared/api/graphql';
import { ListItemAction } from '@client/shared/ui-kit';

import { AccountDialog } from '../AccountDialog';

function getProviderText(name: ExternalAccountProviderName) {
  const TEXTS: Record<ExternalAccountProviderName, string> = {
    [ExternalAccountProviderName.Vk]: 'Вконтакте',
    [ExternalAccountProviderName.Facebook]: 'Facebook',
    [ExternalAccountProviderName.Twitter]: 'Twitter',
    [ExternalAccountProviderName.Mailru]: 'Mail',
    [ExternalAccountProviderName.Google]: 'Google',
    [ExternalAccountProviderName.Odnoklassniki]: 'Одноклассники',
    [ExternalAccountProviderName.Apple]: 'Apple',
    [ExternalAccountProviderName.Esia]: 'ЕСИА',
  };

  return TEXTS[name];
}

export interface AccountActionListItemProps {
  displayName: string;
  provider: ExternalAccountProviderName;
  allowAuth: boolean;
}

export const AccountActionListItem: VFC<AccountActionListItemProps> = (props) => {
  const { displayName, provider, allowAuth } = props;
  const [visible, setVisible] = useState(false);

  const handleOpen = useCallback(() => {
    setVisible(true);
  }, []);

  const handleClose = useCallback(() => {
    setVisible(false);
  }, []);

  return (
    <>
      <ListItemAction
        type="link"
        icon={<ExternalProviderIcon name={provider} size={24} />}
        text={getProviderText(provider)}
        description={displayName}
        onPress={handleOpen}
      />
      <AccountDialog
        visible={visible}
        displayName={displayName}
        provider={provider}
        allowAuth={allowAuth}
        onClose={handleClose}
      />
    </>
  );
};
