/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useCallback } from 'react';

import { ExternalAccountProviderName } from '@client/shared/api/graphql';
import { Button, Dialog, Section, SectionStack } from '@client/shared/ui-kit';

import { AccountActionList } from '../AccountActionList';
import { AccountInfo } from '../AccountInfo';

import styles from './AccountDialog.module.css';

export interface AccountDialogProps {
  displayName: string;
  provider: ExternalAccountProviderName;
  allowAuth: boolean;
  visible: boolean;
  onClose: () => void;
}

export const AccountDialog: VFC<AccountDialogProps> = (props) => {
  const { visible, displayName, provider, allowAuth, onClose } = props;

  const handleClose = useCallback(() => {
    onClose();
  }, [onClose]);

  return (
    <Dialog className={styles.root} visible={visible} onClose={handleClose}>
      <SectionStack className={styles.sectionStack}>
        <Section className={styles.section}>
          <Section.Content className={styles.content}>
            <AccountInfo displayName={displayName} provider={provider} />
          </Section.Content>
        </Section>

        <Section className={styles.section}>
          <Section.Content className={styles.content}>
            <AccountActionList allowAuth={allowAuth} />

            <Button variant="default" size="xl" onPress={handleClose}>
              Закрыть
            </Button>
          </Section.Content>
        </Section>
      </SectionStack>
    </Dialog>
  );
};
